<?php $__env->startSection('title', translate('header')); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <?php echo $__env->make('admin-views.business-settings.vendor-registration-setting.partial.inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <form action="<?php echo e(route('admin.business-settings.vendor-registration-settings.index')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 text-capitalize"><?php echo e(translate('header_section')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="card border shadow-none mb-3">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="title-color"><?php echo e(translate('title')); ?></label>
                                        <input type="text" name="title" class="form-control" value="<?php echo e($vendorRegistrationHeader?->title); ?>" placeholder="<?php echo e(translate('enter_title')); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="title-color text-capitalize"><?php echo e(translate('sub_title')); ?></label>
                                        <input type="text" name="sub_title" class="form-control" value="<?php echo e($vendorRegistrationHeader?->sub_title); ?>" placeholder="<?php echo e(translate('enter_sub_title')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card border shadow-none">
                        <div class="card-body">
                            <div class="mx-auto max-w-400">
                                <div class="mb-3 text-center">
                                    <label for="name" class="title-color text-capitalize font-weight-bold mb-0"><?php echo e(translate('image')); ?></label>
                                    <span class="badge badge-soft-info"><?php echo e('('.translate('size').' : '.'310px x 240px'.')'); ?></span>
                                </div>

                                <div class="custom_upload_input">
                                    <input type="file" name="image"
                                        class="image-input meta-img" data-image-id="view-header-logo"
                                        accept="image/*">
                                    <span class="delete_file_input btn btn-outline-danger btn-sm square-btn d--none">
                                        <i class="tio-delete"></i>
                                    </span>
                                    <div class="img_area_with_preview position-absolute z-index-2">
                                        <?php ($imagePath = imagePathProcessing(imageData:$vendorRegistrationHeader?->image, path: 'vendor-registration-setting')); ?>
                                        <img id="view-header-logo" src="<?php echo e(getStorageImages(path:$imagePath,type: 'backend-banner')); ?>" class="bg-white" alt="">
                                    </div>
                                    <div
                                        class="position-absolute h-100 top-0 w-100 d-flex align-content-center justify-content-center">
                                        <div
                                            class="d-flex flex-column justify-content-center align-items-center">
                                            <img alt="" class="w-75"
                                                src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/icons/product-upload-icon.svg')); ?>">
                                            <h3 class="text-muted text-capitalize"><?php echo e(translate('upload_image')); ?></h3>
                                        </div>
                                    </div>
                                </div>

                                <p class="text-muted text-center mt-2">
                                    <?php echo e(translate('image_format').' : '.'Jpg, png, jpeg, webp,'); ?>

                                    <br>
                                    <?php echo e(translate('image_size').' : '.translate('max').' ' .'2 MB'); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-end gap-3 mt-3 mx-1">
                        <button type="reset" class="btn btn-secondary px-5"><?php echo e(translate('reset')); ?></button>
                        <button type="submit" class="btn btn--primary px-5"><?php echo e(translate('submit')); ?></button>
                    </div>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tupatane/public_html/resources/views/admin-views/business-settings/vendor-registration-setting/header.blade.php ENDPATH**/ ?>