<?php $__env->startSection('title',translate($data['data_from']).' '.translate('products')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e($web_config['web_logo']['path']); ?>"/>
    <meta property="og:title" content="Products of <?php echo e($web_config['name']); ?> "/>
    <meta property="og:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="og:description"
          content="<?php echo e(substr(strip_tags(str_replace('&nbsp;', ' ', $web_config['about']->value)), 0, 160)); ?>">

    <meta property="twitter:card" content="<?php echo e($web_config['web_logo']['path']); ?>"/>
    <meta property="twitter:title" content="Products of <?php echo e($web_config['name']); ?>"/>
    <meta property="twitter:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="twitter:description"
          content="<?php echo e(substr(strip_tags(str_replace('&nbsp;', ' ', $web_config['about']->value)),0,160)); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <?php ($decimal_point_settings = getWebConfig(name: 'decimal_point_settings')); ?>

    <div class="container py-3" dir="<?php echo e(Session::get('direction')); ?>">
        <div class="search-page-header">
            <div>
                <h5 class="font-semibold mb-1 text-capitalize">
                    <span class="current-product-type"
                    data-all="<?php echo e(translate('all')); ?>"
                    data-digital="<?php echo e(translate('digital')); ?>"
                    data-physical="<?php echo e(translate('physical')); ?>">
                        <?php echo e(translate(str_replace('_',' ',$data['data_from']))); ?> <?php echo e(request('product_type') == 'digital' ? translate(request('product_type')) : ''); ?>

                    </span>
                    <?php echo e(translate('products')); ?> <?php echo e(isset($data['brand_name']) ? '('.$data['brand_name'].')' : ''); ?>

                </h5>
                <div><span class="view-page-item-count"><?php echo e($products->total()); ?></span> <?php echo e(translate('items_found')); ?></div>
            </div>
            <form id="search-form" class="d-none d-lg-block" action="<?php echo e(route('products')); ?>" method="GET">
                <input hidden name="data_from" value="<?php echo e($data['data_from']); ?>">
                <div class="sorting-item">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                        <path d="M11.6667 7.80078L14.1667 5.30078L16.6667 7.80078" stroke="#D9D9D9" stroke-width="2"
                              stroke-linecap="round" stroke-linejoin="round"/>
                        <path
                            d="M7.91675 4.46875H4.58341C4.3533 4.46875 4.16675 4.6553 4.16675 4.88542V8.21875C4.16675 8.44887 4.3533 8.63542 4.58341 8.63542H7.91675C8.14687 8.63542 8.33341 8.44887 8.33341 8.21875V4.88542C8.33341 4.6553 8.14687 4.46875 7.91675 4.46875Z"
                            stroke="#D9D9D9" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path
                            d="M7.91675 11.9688H4.58341C4.3533 11.9688 4.16675 12.1553 4.16675 12.3854V15.7188C4.16675 15.9489 4.3533 16.1354 4.58341 16.1354H7.91675C8.14687 16.1354 8.33341 15.9489 8.33341 15.7188V12.3854C8.33341 12.1553 8.14687 11.9688 7.91675 11.9688Z"
                            stroke="#D9D9D9" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M14.1667 5.30078V15.3008" stroke="#D9D9D9" stroke-width="2" stroke-linecap="round"
                              stroke-linejoin="round"/>
                    </svg>
                    <label class="for-sorting" for="sorting">
                        <span><?php echo e(translate('sort_by')); ?></span>
                    </label>
                    <select class="product-list-filter-on-viewpage">
                        <option
                            value="latest" <?php echo e(request('sort_by') == 'latest' ? 'selected':''); ?>><?php echo e(translate('latest')); ?></option>
                        <option
                            value="low-high" <?php echo e(request('sort_by') == 'low-high' ? 'selected':''); ?>><?php echo e(translate('low_to_High_Price')); ?> </option>
                        <option
                            value="high-low" <?php echo e(request('sort_by') == 'high-low' ? 'selected':''); ?>><?php echo e(translate('High_to_Low_Price')); ?></option>
                        <option
                            value="a-z" <?php echo e(request('sort_by') == 'a-z' ? 'selected':''); ?>><?php echo e(translate('A_to_Z_Order')); ?></option>
                        <option
                            value="z-a" <?php echo e(request('sort_by') == 'z-a' ? 'selected':''); ?>><?php echo e(translate('Z_to_A_Order')); ?></option>
                    </select>
                </div>
            </form>
            <div class="d-lg-none">
                <div class="filter-show-btn btn btn--primary py-1 px-2 m-0">
                    <i class="tio-filter"></i>
                </div>
            </div>
        </div>

    </div>

    <div class="container pb-5 mb-2 mb-md-4 rtl __inline-35" dir="<?php echo e(Session::get('direction')); ?>">
        <div class="row">
            <aside
                class="col-lg-3 hidden-xs col-md-3 col-sm-4 SearchParameters __search-sidebar <?php echo e(Session::get('direction') === "rtl" ? 'pl-2' : 'pr-2'); ?>"
                id="SearchParameters">
                <div class="cz-sidebar __inline-35 p-4 overflow-hidden" id="shop-sidebar">
                    <div class="cz-sidebar-header p-0">
                        <h6 class="font-semibold fs-20 mb-2"><?php echo e(translate('Sidebar')); ?></h6>
                        <button class="close ms-auto fs-18-mobile"
                                type="button" data-dismiss="sidebar" aria-label="Close">
                            <i class="tio-clear"></i>
                        </button>
                    </div>
                    <div class="pb-0 shop-sidebar-scroll">
                        <div class="d-flex gap-3 flex-column">
                            <div class="">
                                <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('filter')); ?></h6>
                                <label class="w-100 opacity-75 text-nowrap for-sorting d-block mb-0 ps-0" for="sorting">
                                    <select class="form-control custom-select filter-on-product-filter-change">
                                        <option selected disabled><?php echo e(translate('Choose')); ?></option>
                                        <option
                                            value="best-selling" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='best-selling'?'selected':'':''); ?>><?php echo e(translate('Best_Selling_Product')); ?></option>
                                        <option
                                            value="top-rated" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='top-rated'?'selected':'':''); ?>><?php echo e(translate('Top_Rated')); ?></option>
                                        <option
                                            value="most-favorite" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='most-favorite'?'selected':'':''); ?>><?php echo e(translate('Most_Favorite')); ?></option>
                                        <option
                                            value="featured_deal" <?php echo e(isset($data['data_from'])!=null?$data['data_from']=='featured_deal'?'selected':'':''); ?>><?php echo e(translate('Featured_Deal')); ?></option>
                                    </select>
                                </label>
                            </div>

                            <?php if($web_config['digital_product_setting']): ?>
                            <div class="">
                                <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('Product_Type')); ?></h6>
                                <label class="w-100 opacity-75 text-nowrap for-sorting d-block mb-0 ps-0" for="sorting">
                                    <select class="form-control custom-select filter-on-product-type-change">
                                        <option value="all" <?php echo e(!request('product_type') ? 'selected' : ''); ?>><?php echo e(translate('All')); ?></option>
                                        <option value="physical" <?php echo e(request('product_type') == 'physical' ? 'selected' : ''); ?>>
                                            <?php echo e(translate('physical')); ?>

                                        </option>
                                        <option value="digital" <?php echo e(request('product_type') == 'digital' ? 'selected' : ''); ?>>
                                            <?php echo e(translate('digital')); ?>

                                        </option>
                                    </select>
                                </label>
                            </div>
                            <?php endif; ?>

                            <div class="d-lg-none">
                                <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('Sort_By')); ?></h6>
                                <form id="search-form" action="<?php echo e(route('products')); ?>" method="GET">
                                    <input hidden name="data_from" value="<?php echo e($data['data_from']); ?>">
                                    <select class="form-control product-list-filter-on-viewpage">
                                        <option value="latest"><?php echo e(translate('latest')); ?></option>
                                        <option
                                            value="low-high"><?php echo e(translate('low_to_High_Price')); ?> </option>
                                        <option
                                            value="high-low"><?php echo e(translate('High_to_Low_Price')); ?></option>
                                        <option
                                            value="a-z"><?php echo e(translate('A_to_Z_Order')); ?></option>
                                        <option
                                            value="z-a"><?php echo e(translate('Z_to_A_Order')); ?></option>
                                    </select>
                                </form>
                            </div>

                            <div>
                                <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('price')); ?></h6>
                                <div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="__w-35p">
                                            <input
                                                class="bg-white cz-filter-search form-control form-control-sm appended-form-control"
                                                type="number" value="0" min="0" max="1000000" id="min_price"
                                                placeholder="<?php echo e(translate('min')); ?>">
                                        </div>
                                        <div class="__w-10p">
                                            <p class="m-0"><?php echo e(translate('to')); ?></p>
                                        </div>
                                        <div class="__w-35p">
                                            <input value="100000000000" min="10" max="100000000000"
                                                   class="bg-white cz-filter-search form-control form-control-sm appended-form-control"
                                                   type="number" id="max_price" placeholder="<?php echo e(translate('max')); ?>">
                                        </div>

                                        <div class="d-flex justify-content-center align-items-center __number-filter-btn">
                                            <a class="action-search-products-by-price">
                                                <i class="__inline-37 czi-arrow-<?php echo e(Session::get('direction') === "rtl" ? 'left' : 'right'); ?>"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div>
                                <h6 class="font-semibold fs-15 mb-3"><?php echo e(translate('categories')); ?></h6>
                                <div class="accordion mt-n1 product-categories-list" id="shop-categories">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="menu--caret-accordion">
                                            <div class="card-header flex-between">
                                                <div>
                                                    <label class="for-hover-label cursor-pointer get-view-by-onclick"
                                                           data-link="<?php echo e(route('products',['category_id'=> $category['id'],'data_from'=>'category','page'=>1])); ?>">
                                                        <?php echo e($category['name']); ?>

                                                    </label>
                                                </div>
                                                <div class="px-2 cursor-pointer menu--caret">
                                                    <strong class="pull-right for-brand-hover">
                                                        <?php if($category->childes->count()>0): ?>
                                                            <i class="tio-next-ui fs-13"></i>
                                                        <?php endif; ?>
                                                    </strong>
                                                </div>
                                            </div>
                                            <div
                                                class="card-body p-0 ms-2 d--none"
                                                id="collapse-<?php echo e($category['id']); ?>">
                                                <?php $__currentLoopData = $category->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="menu--caret-accordion">
                                                        <div class="for-hover-label card-header flex-between">
                                                            <div>
                                                                <label class="cursor-pointer get-view-by-onclick"
                                                                       data-link="<?php echo e(route('products',['category_id'=> $child['id'],'data_from'=>'category','page'=>1])); ?>">
                                                                    <?php echo e($child['name']); ?>

                                                                </label>
                                                            </div>
                                                            <div class="px-2 cursor-pointer menu--caret">
                                                                <strong class="pull-right">
                                                                    <?php if($child->childes->count()>0): ?>
                                                                        <i class="tio-next-ui fs-13"></i>
                                                                    <?php endif; ?>
                                                                </strong>
                                                            </div>
                                                        </div>
                                                        <div
                                                            class="card-body p-0 ms-2 d--none"
                                                            id="collapse-<?php echo e($child['id']); ?>">
                                                            <?php $__currentLoopData = $child->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="card-header">
                                                                    <label
                                                                        class="for-hover-label d-block cursor-pointer text-left get-view-by-onclick"
                                                                        data-link="<?php echo e(route('products',['category_id'=> $ch['id'],'data_from'=>'category','page'=>1])); ?>">
                                                                        <?php echo e($ch['name']); ?>

                                                                    </label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>

                            <?php if($web_config['brand_setting']): ?>
                                <div class="product-type-physical-section search-product-attribute-container">
                                    <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('brands')); ?></h6>
                                    <div class="pb-2">
                                        <div class="input-group-overlay input-group-sm">
                                            <input placeholder="<?php echo e(translate('search_by_brands')); ?>"
                                                   class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control search-product-attribute"
                                                   type="text">
                                            <div class="input-group-append-overlay">
                                        <span class="input-group-text">
                                            <i class="czi-search"></i>
                                        </span>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="__brands-cate-wrap attribute-list" data-simplebar
                                        data-simplebar-auto-hide="false">
                                        <?php $__currentLoopData = $activeBrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <ul
                                                class="brand mt-2 p-0 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>"
                                                id="brand">
                                                <li class="flex-between get-view-by-onclick cursor-pointer"
                                                    data-link="<?php echo e(route('products',['brand_id'=> $brand['id'],'data_from'=>'brand','page'=>1])); ?>">
                                                    <div class="text-start">
                                                        <?php echo e($brand['name']); ?>

                                                    </div>
                                                    <div class="__brands-cate-badge">
                                                    <span>
                                                        <?php echo e($brand['brand_products_count']); ?>

                                                    </span>
                                                    </div>
                                                </li>
                                            </ul>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if($web_config['digital_product_setting'] && count($web_config['publishing_houses']) > 0): ?>
                                <div class="product-type-digital-section search-product-attribute-container">
                                    <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('Publishing_House')); ?></h6>
                                    <div class="pb-2">
                                        <div class="input-group-overlay input-group-sm">
                                            <input placeholder="<?php echo e(translate('search_by_name')); ?>"
                                                   class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control search-product-attribute"
                                                   type="text">
                                            <div class="input-group-append-overlay">
                                                    <span class="input-group-text">
                                                        <i class="czi-search"></i>
                                                    </span>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="__brands-cate-wrap attribute-list" data-simplebar
                                        data-simplebar-auto-hide="false">
                                        <?php $__currentLoopData = $web_config['publishing_houses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $publishingHouseItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <ul class="brand mt-2 p-0 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>"
                                                 id="brand">
                                                <li class="flex-between get-view-by-onclick cursor-pointer pe-2"
                                                    data-link="<?php echo e(route('products',['publishing_house_id'=> $publishingHouseItem['id'], 'product_type' => 'digital', 'page'=>1])); ?>">
                                                    <div class="text-start">
                                                        <?php echo e($publishingHouseItem['name']); ?>

                                                    </div>
                                                    <div class="__brands-cate-badge">
                                                            <span>
                                                                <?php echo e($publishingHouseItem['publishing_house_products_count']); ?>

                                                            </span>
                                                    </div>
                                                </li>
                                            </ul>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                            <?php if($web_config['digital_product_setting'] && count($web_config['digital_product_authors']) > 0): ?>
                                <div class="product-type-digital-section search-product-attribute-container">
                                    <h6 class="font-semibold fs-15 mb-2">
                                        <?php echo e(translate('authors')); ?>/<?php echo e(translate('Creator')); ?>/<?php echo e(translate('Artist')); ?>

                                    </h6>
                                    <div class="pb-2">
                                        <div class="input-group-overlay input-group-sm">
                                            <input placeholder="<?php echo e(translate('search_by_name')); ?>"
                                                   class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control search-product-attribute"
                                                   type="text">
                                            <div class="input-group-append-overlay">
                                                <span class="input-group-text">
                                                    <i class="czi-search"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="__brands-cate-wrap attribute-list" data-simplebar
                                        data-simplebar-auto-hide="false">
                                        <?php $__currentLoopData = $web_config['digital_product_authors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productAuthor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <ul class="brand mt-2 p-0 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>"
                                                 id="brand">
                                                <li class="flex-between get-view-by-onclick cursor-pointer pe-2"
                                                    data-link="<?php echo e(route('products',['author_id' => $productAuthor['id'], 'product_type' => 'digital', 'page' => 1])); ?>">
                                                    <div class="text-start">
                                                        <?php echo e($productAuthor['name']); ?>

                                                    </div>
                                                    <div class="__brands-cate-badge">
                                                        <span>
                                                            <?php echo e($productAuthor['digital_product_author_count']); ?>

                                                        </span>
                                                    </div>
                                                </li>
                                            </ul>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>

                        </div>
                    </div>

                </div>
                <div class="sidebar-overlay"></div>
            </aside>

            <section class="col-lg-9">
                <div class="row" id="ajax-products">
                    <?php echo $__env->make('web-views.products._ajax-products',['products'=>$products,'decimal_point_settings'=>$decimal_point_settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </section>
        </div>
    </div>

    <span id="products-search-data-backup"
          data-url="<?php echo e(route('products')); ?>"
          data-brand="<?php echo e($data['brand_id'] ?? ''); ?>"
          data-category="<?php echo e($data['category_id'] ?? ''); ?>"
          data-name="<?php echo e($data['name']); ?>"
          data-from="<?php echo e($data['data_from'] ?? $data['product_type']); ?>"
          data-sort="<?php echo e($data['sort_by']); ?>"
          data-product-type="<?php echo e($data['product_type']); ?>"
          data-min-price="<?php echo e($data['min_price']); ?>"
          data-max-price="<?php echo e($data['max_price']); ?>"
          data-message="<?php echo e(translate('items_found')); ?>"
          data-publishing-house-id="<?php echo e(request('publishing_house_id')); ?>"
          data-author-id="<?php echo e(request('author_id')); ?>"
    ></span>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(theme_asset(path: 'public/assets/front-end/js/product-view.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/kariakooyetu/public_html/resources/themes/default/web-views/products/view.blade.php ENDPATH**/ ?>