<?php
    use App\Enums\GlobalConstant;
    use App\Utils\FileManagerLogic;
?>
<?php if(isset($chattingMessages)): ?>
    <?php $__currentLoopData = $chattingMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($message->sent_by_seller || $message->sent_by_admin || $message->sent_by_delivery_man): ?>
            <div class="incoming_msg d-flex" data-toggle="tooltip"
                 <?php if($message->created_at->diffInDays() > 6): ?>
                     title="<?php echo e($message->created_at->format('M-d-Y H:i:s')); ?>"
                 <?php else: ?>
                     title="<?php echo e($message->created_at->format('l H:i:s')); ?>"
                <?php endif; ?>
            >
                <div class="incoming_msg_img">
                    <img src="<?php echo e($userType == 'admin' ? getStorageImages(path: $web_config['fav_icon'], type: 'shop') : ( $userType == 'vendor' ? getStorageImages(path: $message?->shop?->image_full_url, type: 'shop') : getStorageImages(path: $message?->deliveryMan?->image_full_url, type: 'avatar'))); ?>"
                         alt="Image Description">
                </div>
                <div class="received_msg">
                    <div class="received_withdraw_msg">
                        <?php if($message->message): ?>
                            <p>
                                <?php echo e($message->message); ?>

                            </p>
                        <?php endif; ?>
                        <?php if(count($message->attachment_full_url) >0): ?>
                            <div class="row g-2 flex-wrap mt-3">
                                <?php $__currentLoopData = $message->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php ($extension = strrchr($attachment['key'],'.')); ?>
                                    <?php if(in_array($extension,GlobalConstant::DOCUMENT_EXTENSION)): ?>
                                        <?php ($icon = in_array($extension,['.pdf','.doc','docx','.txt']) ? 'word-icon': 'default-icon'); ?>
                                        <?php ($downloadPath = $attachment['path']); ?>
                                        <div class="d-flex gap-2 mt-2">
                                            <a href="<?php echo e($downloadPath); ?>" target="_blank">
                                                <div class="uploaded-file-item gap-2"><img
                                                        src="<?php echo e(dynamicAsset('public/assets/front-end/img/word-icon/'.$icon.'.png')); ?>"
                                                        class="file-icon" alt="">
                                                    <div class="upload-file-item-content">
                                                        <div>
                                                            <?php echo e(($attachment['key'])); ?>

                                                        </div>
                                                        <small><?php echo e(FileManagerLogic::getFileSize($downloadPath)); ?></small>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="col-6 col-md-4 img_row<?php echo e($index); ?> <?php echo e($index > 2 ? 'd-none' : ''); ?>">
                                            <div class="aspect-1 overflow-hidden d-block rounded-16px position-relative">
                                                <a data-lightbox="mygallery<?php echo e($message['id']); ?>" href="<?php echo e($attachment['path']); ?>" class="aspect-1 overflow-hidden d-block border rounded">
                                                    <img class="img-fit" alt="<?php echo e(translate('chatting')); ?>"
                                                         src="<?php echo e(getStorageImages(path: $attachment, type: 'product')); ?>">
                                                    <?php if($index > 1): ?>
                                                        <div class="extra-images show-extra-images">
                                                            <span class="extra-image-count">
                                                                +<?php echo e(count($message->attachment_full_url) - $index); ?>

                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="outgoing_msg" data-toggle="tooltip"
                 <?php if($message->created_at->diffInDays() > 6): ?>
                     title="<?php echo e($message->created_at->format('M-d-Y H:i:s')); ?>"
                 <?php else: ?>
                     title="<?php echo e($message->created_at->format('l H:i:s')); ?>"
                <?php endif; ?>
            >
                <div class="send_msg">
                    <?php if($message->message): ?>
                        <p class="btn--primary">
                            <?php echo e($message->message); ?>

                        </p>
                    <?php endif; ?>
                    <?php if(count($message->attachment_full_url) >0): ?>
                        <div class="row g-2 flex-wrap mt-3 justify-content-end">
                            <?php $__currentLoopData = $message->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secondIndex => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php ($extension = strrchr($attachment['key'],'.')); ?>
                                <?php if(in_array($extension,GlobalConstant::DOCUMENT_EXTENSION)): ?>
                                    <?php ($icon = in_array($extension,['.pdf','.doc','docx','.txt']) ? 'word-icon': 'default-icon'); ?>
                                    <?php ($downloadPath = $attachment['path']); ?>
                                    <div class="d-flex gap-2 mt-2">
                                        <a href="<?php echo e($downloadPath); ?>" target="_blank">
                                            <div class="uploaded-file-item gap-2"><img
                                                    src="<?php echo e(theme_asset('public/assets/front-end/img/word-icon/'.$icon.'.png')); ?>"
                                                    class="file-icon" alt="">
                                                <div class="upload-file-item-content">
                                                    <div>
                                                        <?php echo e(($attachment['key'])); ?>

                                                    </div>
                                                    <small><?php echo e(FileManagerLogic::getFileSize($downloadPath)); ?></small>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                <?php else: ?>
                                    <div class="col-6 col-md-4 img_row<?php echo e($secondIndex); ?> <?php echo e($secondIndex > 2 ? 'd-none' : ''); ?>">
                                        <div class="aspect-1 overflow-hidden d-block rounded-16px position-relative">
                                            <a data-lightbox="mygallery<?php echo e($message['id']); ?>" href="<?php echo e($attachment['path']); ?>" class="aspect-1 overflow-hidden d-block border rounded">
                                                <img class="img-fit" alt="<?php echo e(translate('chatting')); ?>"
                                                     src="<?php echo e(getStorageImages(path: $attachment, type: 'product')); ?>">
                                                <?php if($secondIndex > 1 ): ?>
                                                    <div class="extra-images show-extra-images">
                                                            <span class="extra-image-count">
                                                                +<?php echo e(count($message->attachment_full_url) - $secondIndex); ?>

                                                            </span>
                                                    </div>
                                                <?php endif; ?>
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <div id="down"></div>
<?php endif; ?>
<?php /**PATH /data/sdmkinga/tupatane.store/resources/themes/default/web-views/users-profile/inbox/messages.blade.php ENDPATH**/ ?>