<?php $__env->startSection('title', translate('product_gallery')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div>
            <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
                <h2 class="h1 mb-0">
                    <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/all-orders.png')); ?>" class="mb-1 mr-1" alt="">
                    <?php echo e(translate('product_gallery')); ?>

                </h2>
                <span class="badge badge-soft-dark radius-50 fz-14"><?php echo e($products->total()); ?></span>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="row gx-2">
                        <div class="col-sm-6 col-lg-4">
                            <div class="form-group">
                                <label class="title-color" for="store"><?php echo e(translate('brand')); ?></label>
                                <select name="brand_id" class="form-control js-select2-custom product-gallery-filter">
                                    <option value="all"><?php echo e(translate('all_brand')); ?></option>
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($brand['id']); ?>" <?php echo e($brand['id'] == request('brand_id') ? 'selected': ''); ?>><?php echo e($brand['defaultName']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4">
                            <div class="form-group">
                                <label class="title-color" for="store"><?php echo e(translate('category')); ?></label>
                                <select name="category_id" class="form-control js-select2-custom product-gallery-filter">
                                    <option value="all"><?php echo e(translate('all_category')); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category['id']); ?>" <?php echo e($category['id'] == request('category_id') ? 'selected': ''); ?>><?php echo e($category['defaultName']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4 d-flex align-items-center">
                            <form action="<?php echo e(url()->current()); ?>">
                                <div class="input-group input-group-merge input-group-custom">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="tio-search"></i>
                                        </div>
                                    </div>
                                    <input type="search" name="searchValue" class="form-control"
                                           placeholder="<?php echo e(translate('search_by_product_name')); ?>"
                                           aria-label="Search orders" value="<?php echo e(request('searchValue')); ?>">
                                    <button type="submit" class="btn btn--primary"><?php echo e(translate('search')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3 refund-details-card--2 p-3">
                            <div class="d-flex gap-3 flex-wrap flex-md-nowrap justify-content-center justify-content-md-start">
                                <div class="media flex-nowrap flex-column flex-sm-row gap-3">
                                    <div class="d-flex flex-column align-items-center __min-w-165px">
                                        <a class="aspect-1 float-left overflow-hidden"
                                           href="<?php echo e(getStorageImages(path:$product->thumbnail_full_url,type: 'backend-product')); ?>"
                                           data-lightbox="product-gallery-<?php echo e($product['id']); ?>">
                                            <img class="avatar avatar-170 rounded object-fit-cover"
                                                 src="<?php echo e(getStorageImages(path:$product->thumbnail_full_url,type: 'backend-product')); ?>"
                                                 alt="">
                                        </a>
                                    </div>
                                </div>
                                <div class="row gy-2 flex-grow-1">
                                    <div class="col-12">
                                        <div class="d-md-flex justify-content-md-between">
                                            <h4 class="text-capitalize"><?php echo e($product['name']); ?></h4>
                                            <a class="btn btn--primary btn-sm" href="<?php echo e(route('vendor.products.update',['id'=>$product['id'],'product-gallery'=>1])); ?>">
                                                <?php echo e(translate('use_this_product_info')); ?>

                                            </a>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-xl-4">
                                        <h4 class="mb-3 text-capitalize"><?php echo e(translate('general_information')); ?></h4>
                                        <div class="pair-list">
                                            <div>
                                                <span class="key text-nowrap"><?php echo e(translate('brand')); ?></span>
                                                <span>:</span>
                                                <span class="value">
                                            <?php echo e(isset($product->brand) ? $product->brand->default_name : translate('brand_not_found')); ?>

                                        </span>
                                            </div>

                                            <div>
                                                <span class="key text-nowrap"><?php echo e(translate('category')); ?></span>
                                                <span>:</span>
                                                <span class="value">
                                            <?php echo e(isset($product->category) ? $product->category->default_name : translate('category_not_found')); ?>

                                        </span>
                                            </div>

                                            <div>
                                                <span class="key text-nowrap text-capitalize"><?php echo e(translate('product_type')); ?></span>
                                                <span>:</span>
                                                <span class="value"><?php echo e(translate($product->product_type)); ?></span>
                                            </div>
                                            <?php if($product->product_type == 'physical'): ?>
                                                <div>
                                                    <span class="key text-nowrap text-capitalize"><?php echo e(translate('product_unit')); ?></span>
                                                    <span>:</span>
                                                    <span class="value"><?php echo e($product['unit']); ?></span>
                                                </div>
                                                <div>
                                                    <span class="key text-nowrap"><?php echo e(translate('current_Stock')); ?></span>
                                                    <span>:</span>
                                                    <span class="value"><?php echo e($product->current_stock); ?></span>
                                                </div>
                                            <?php endif; ?>
                                            <div>
                                                <span class="key text-nowrap"><?php echo e(translate('product_SKU')); ?></span>
                                                <span>:</span>
                                                <span class="value"><?php echo e($product->code); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($product->product_type == 'physical' && count(json_decode($product->choice_options)) >0 || count(json_decode($product->colors)) >0 ): ?>
                                        <div class="col-sm-6 col-xl-4">
                                        <h4 class="mb-3"><?php echo e(translate('available_variations')); ?></h4>
                                        <div class="pair-list">
                                            <?php if(json_decode($product->choice_options) != null): ?>
                                                <?php $__currentLoopData = json_decode($product->choice_options); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div>
                                                        <?php if(array_filter($value->options) != null): ?>
                                                            <span class="key text-nowrap"><?php echo e(translate($value->title)); ?></span>
                                                            <span>:</span>
                                                            <span class="value">
                                                    <?php $__currentLoopData = $value->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e($option); ?>

                                                                    <?php if($index === array_key_last(($value->options))): ?>
                                                                        <?php break; ?>
                                                                    <?php endif; ?>
                                                                    ,
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </span>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <?php if(isset($product['colorsName'])): ?>
                                                <div>
                                                    <span class="key text-nowrap"><?php echo e(translate('color')); ?></span>
                                                    <span>:</span>
                                                    <span class="value">
                                                        <?php $__currentLoopData = $product['colorsName']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php echo e($color); ?>

                                                            <?php if($key === array_key_last($product['colorsName'])): ?>
                                                                <?php break; ?>
                                                            <?php endif; ?>
                                                            ,
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if(count($product->tags)>0): ?>
                                        <div class="col-sm-6 col-xl-4">
                                            <h4 class="mb-3"><?php echo e(translate('tags')); ?></h4>
                                            <div class="pair-list"><div>
                                            <span class="value">
                                                <?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($tag['tag']); ?>

                                                    <?php if($key === (count($product->tags)-1)): ?>
                                                        <?php break; ?>
                                                    <?php endif; ?>
                                                    ,
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div class="view--more rich-editor-html-content">
                                    <label class="text-gulf-blue font-weight-bold"><?php echo e(translate('description').' : '); ?></label>
                                    <?php echo $product['details']; ?>

                                    <button class="no-gutter expandable-btn d-none">
                                        <span class="more"><?php echo e(translate('view_more')); ?></span>
                                        <span class="less d-none"><?php echo e(translate('view_less')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php if(count($products)==0): ?>
                    <?php echo $__env->make('layouts.back-end._empty-state',['text'=>'no_product_found'],['image'=>'default'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </div>
            <div class=" mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <?php echo e($products->links()); ?>

                </div>
            </div>

        </div>
    </div>
    <span id="get-product-gallery-route" data-action="<?php echo e(route('vendor.products.product-gallery')); ?>" data-brand-id="<?php echo e(request('brand_id')); ?>" data-category-id="<?php echo e(request('category_id')); ?>" data-vendor-id="<?php echo e(request('vendor_id')); ?>">
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/kariakooyetu/public_html/resources/views/vendor-views/product/product-gallery.blade.php ENDPATH**/ ?>