<?php if(count($generateCombination) > 0): ?>
    <div class="card-header">
        <div class="d-flex gap-2">
            <i class="tio-user-big"></i>
            <h4 class="mb-0"><?php echo e(translate('file_upload')); ?></h4>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-borderless align-middle">
                <thead class="thead-light thead-50 text-capitalize">
                <tr>
                    <th class="text-center"><?php echo e(translate('SL')); ?></th>
                    <th class="text-center"><?php echo e(translate('Product_Variation')); ?></th>
                    <th class="text-center"><?php echo e(translate('Price')); ?>

                        (<?php echo e(getCurrencySymbol(currencyCode: getCurrencyCode())); ?>)
                    </th>
                    <th class="text-center"><?php echo e(translate('SKU')); ?></th>
                    <?php if($digitalProductType == 'ready_product'): ?>
                        <th>
                            <div class="d-flex justify-content-center align-items-center gap-1">
                                <span><?php echo e(translate('Upload_File')); ?></span>
                                <span class="input-label-secondary cursor-pointer mb-1" data-toggle="tooltip"
                                      title="<?php echo e(translate('it_can_be_possible_to_upload_all_types_of_audio,_video_and_documentation_and_software_files.')); ?>">
                            <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/info-circle.svg')); ?>"
                                 alt="">
                        </span>
                            </div>
                        </th>
                    <?php endif; ?>
                </tr>
                </thead>
                <tbody>

                <?php
                    $serial = 1;
                ?>

                <?php $__currentLoopData = $generateCombination; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $combinationKey => $combination): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center">
                            <?php echo e($serial++); ?>

                        </td>
                        <td class="text-center">
                            <label for="" class="control-label"><?php echo e($combination['variant_key']); ?></label>
                            <input type="hidden" name="digital_product_variant_key[<?php echo e($combination['unique_key']); ?>]"
                                   value="<?php echo e($combination['variant_key']); ?>">
                        </td>
                        <td>
                            <input type="number" name="digital_product_price[<?php echo e($combination['unique_key']); ?>]"
                                   value="<?php echo e(usdToDefaultCurrency(amount: $combination['price'])); ?>" min="0" step="0.01"
                                   class="form-control variation-price-input remove-symbol" required
                                   placeholder="<?php echo e(translate('ex').': 100'); ?>">
                        </td>
                        <td>
                            <input type="text" name="digital_product_sku[<?php echo e($combination['unique_key']); ?>]"
                                   value="<?php echo e(strtoupper($combination['sku'])); ?>" class="form-control store-keeping-unit"
                                   required>
                        </td>

                        <?php if($digitalProductType == 'ready_product'): ?>
                            <td>
                                <div class="variation-upload-item">
                                    <label class="variation-upload-file <?php echo e($combination['file'] ? 'collapse' : ''); ?>">
                                        <input type="file" class="d-none" accept=""
                                               name="digital_files[<?php echo e($combination['unique_key']); ?>]">
                                        <img
                                            src="<?php echo e(dynamicAsset(path: '/public/assets/back-end/img/upload-icon.png')); ?>"
                                            alt="">
                                        <span><?php echo e(translate('Upload_File')); ?></span>
                                    </label>

                                    <div class="variation-upload-file uploading-item collapse">
                                        <img
                                            src="<?php echo e(dynamicAsset(path: '/public/assets/back-end/img/upload-icon.png')); ?>"
                                            alt="">
                                        <span class="mr-auto text--title"><?php echo e(translate('Uploading')); ?></span>
                                        <button class="no-gutter cancel-upload" type="button">
                                            <img
                                                src="<?php echo e(dynamicAsset(path: '/public/assets/back-end/img/cancel-icon.png')); ?>"
                                                alt="">
                                        </button>
                                    </div>

                                    <div
                                        class="variation-upload-file uploaded-item <?php echo e($combination['file'] ? '' : 'collapse'); ?>">
                                        <span class="mr-auto text--title file-name">
                                            <?php echo e($combination['file']); ?>

                                        </span>

                                        <?php if($combination['file']): ?>
                                            <button class="no-gutter cancel-upload digital-variation-file-delete-button"
                                                    type="button"
                                                    data-product="<?php echo e($combination['product_id']); ?>"
                                                    data-variant="<?php echo e($combination['variant_key']); ?>">
                                                <img
                                                    src="<?php echo e(dynamicAsset(path: '/public/assets/back-end/img/delete-icon.png')); ?>"
                                                    alt="">
                                            </button>
                                        <?php else: ?>
                                            <button class="no-gutter cancel-upload" type="button">
                                                <img
                                                    src="<?php echo e(dynamicAsset(path: '/public/assets/back-end/img/delete-icon.png')); ?>"
                                                    alt="">
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php endif; ?>

<?php if(count($generateCombination) <= 0): ?>
    <?php if($digitalProductType == 'ready_product' && (!isset($request['extensions_type']) || count($request['extensions_type']) <= 0)): ?>
        <div class="card-header">
            <div class="d-flex gap-2">
                <i class="tio-user-big"></i>
                <h4 class="mb-0">
                    <?php echo e(translate('file_upload')); ?>

                </h4>
            </div>
        </div>
        <div class="card-body">
            <div class="form-group mb-0">
                <div class="input-group">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" name="digital_file_ready"
                               id="inputGroupFile01" aria-describedby="inputGroupFileAddon01">
                        <label class="custom-file-label" for="inputGroupFile01">
                            <?php echo e(translate('choose_file')); ?>

                        </label>
                    </div>
                </div>
                <div class="mt-2"><?php echo e(translate('file_type')); ?>: <?php echo e("jpg, jpeg, png, gif, zip, pdf"); ?></div>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/tupatane/public_html/resources/views/admin-views/product/partials/_digital-variation-combination.blade.php ENDPATH**/ ?>