<?php if(count($products) > 0): ?>
    <ul class="list-group list-unstyled gap-3">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li class="select-product-item">
                <div class="select-product-item media gap-3 border-bottom py-2 cursor-pointer action-select-product"
                     data-id="<?php echo e($product['id']); ?>">
                    <img class="avatar avatar-xl border" width="75"
                         src="<?php echo e(getStorageImages(path: $product?->thumbnail_full_url ?? '', type: 'backend-product')); ?>"
                         alt="">
                    <div class="media-body d-flex flex-column gap-1">
                        <h6 class="product-id" hidden><?php echo e($product['id']); ?></h6>
                        <h6 class="fz-13 mb-1 text-truncate custom-width product-name "><?php echo e($product['name']); ?></h6>
                        <div class="fz-10"><?php echo e(translate('category')); ?>: <?php echo e($product?->category?->name ?? 'N/a'); ?></div>
                        <div class="fz-10"><?php echo e(translate('brand_Name')); ?>: <?php echo e($product?->brand?->name); ?></div>
                        <?php if($product->added_by == 'admin'): ?>
                            <div class="fz-10"><?php echo e(translate('vendor')); ?>: <?php echo e($web_config['name']->value); ?></div>
                        <?php else: ?>
                            <div class="fz-10">
                                <?php echo e(translate('vendor')); ?>

                                : <?php echo e(isset($product?->seller) ? $product?->seller?->shop?->name : translate('shop_not_found')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php else: ?>
    <div>
        <h5 class="m-0 text-muted"><?php echo e(translate('No_Product_Found')); ?></h5>
    </div>
<?php endif; ?>
<?php /**PATH /data/kariakooyetu/public_html/resources/views/vendor-views/partials/_search-product.blade.php ENDPATH**/ ?>