<?php if(isset($product) && isset($metaContentData)): ?>
    <?php if($metaContentData?->title): ?>
        <meta property="title" content="<?php echo e($metaContentData?->title); ?>">
        <meta property="og:title" content="<?php echo e($metaContentData?->title); ?>">
        <meta property="twitter:title" content="<?php echo e($metaContentData?->title); ?>">
    <?php else: ?>
        <meta property="title" content="<?php echo e($product?->name); ?>">
        <meta property="og:title" content="<?php echo e($product?->name); ?>">
        <meta property="twitter:title" content="<?php echo e($product?->name); ?>">
    <?php endif; ?>

    <?php if($metaContentData?->description): ?>
        <meta name="description" content="<?php echo Str::limit($metaContentData?->description, 160); ?>">
        <meta property="description" content="<?php echo Str::limit($metaContentData?->description, 160); ?>">
        <meta property="og:description" content="<?php echo Str::limit($metaContentData?->description, 160); ?>">
        <meta property="twitter:description" content="<?php echo Str::limit($metaContentData?->description, 160); ?>">
    <?php else: ?>
        <meta property="og:description" content="<?php $__currentLoopData = explode(' ',$product['name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($keyword.' , '); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
        <meta property="twitter:description" content="<?php $__currentLoopData = explode(' ',$product['name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($keyword.' , '); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">
    <?php endif; ?>

    <meta property="keywords" content="<?php $__currentLoopData = explode(' ',$product['name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($keyword.' , '); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>">

    <?php if($product->added_by == 'seller'): ?>
        <meta property="author" content="<?php echo e($product->seller->shop?$product->seller->shop->name:$product->seller->f_name); ?>">
    <?php elseif($product->added_by == 'admin'): ?>
        <meta property="author" content="<?php echo e($web_config['name']->value); ?>">
    <?php endif; ?>

    <meta property="og:image" content="<?php echo e($metaContentData?->image_full_url['path']); ?>">
    <meta property="twitter:image" content="<?php echo e($metaContentData?->image_full_url['path']); ?>">

    <meta property="og:url" content="<?php echo e(route('product', [$product->slug])); ?>">
    <meta property="twitter:url" content="<?php echo e(route('product', [$product->slug])); ?>">

    <?php if($metaContentData?->index != 'noindex'): ?>
        <meta property="robots" content="index">
    <?php endif; ?>

    <?php if($metaContentData?->no_follow || $metaContentData?->no_image_index || $metaContentData?->no_archive || $metaContentData?->no_snippet): ?>
        <meta property="robots" content="<?php echo e(($metaContentData?->no_follow ? 'nofollow' : '') . ($metaContentData?->no_image_index ? ' noimageindex' : '') . ($metaContentData?->no_archive ? ' noarchive' : '') . ($metaContentData?->no_snippet ? ' nosnippet' : '')); ?>">
    <?php endif; ?>

    <?php if($metaContentData?->meta_max_snippet): ?>
        <meta property="robots" content="max-snippet<?php echo e($metaContentData?->max_snippet_value ? ': ' . $metaContentData?->max_snippet_value : ''); ?>">
    <?php endif; ?>

    <?php if($metaContentData?->max_video_preview): ?>
        <meta property="robots" content="max-video-preview<?php echo e($metaContentData?->max_video_preview_value ? ': ' . $metaContentData?->max_video_preview_value : ''); ?>">
    <?php endif; ?>

    <?php if($metaContentData?->max_image_preview): ?>
        <meta property="robots" content="max-image-preview<?php echo e($metaContentData?->max_image_preview_value ? ': ' . $metaContentData?->max_image_preview_value : ''); ?>">
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/tupatane/public_html/resources/themes/default/web-views/partials/_productSEOMetaContentData.blade.php ENDPATH**/ ?>