<?php $__env->startSection('title', translate('SEO_Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex justify-content-between align-items-center gap-3 mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/seo-settings.svg')); ?>" alt="">
                <?php echo e(translate('SEO_Settings')); ?>

            </h2>
        </div>
        <?php echo $__env->make('admin-views.business-settings.seo-settings._inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="card shadow-none">
            <div class="card-header">
                <div class="w-100">
                    <h4 class="title m-0"><?php echo e(translate('Site_Map')); ?></h4>
                    <p class="m-0"><?php echo e(translate("Organized_for_navigation_and_search_engine_optimization.")); ?></p>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-20px">
                    <div class="d-flex align-items-center gap-2 fs-12 p-3 rounded badge--info">
                        <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/idea.png')); ?>" alt="">
                        <div class="w-0 flex-grow">
                            <?php echo e(translate('a_sitemap_is_an_xml_file_that_contains_all_the_web_pages_of_a_website.')); ?>

                            <?php echo e(translate('here_we_list_and_organize_all_the_default_pages_in_a_hierarchical_structure_of_your_website_through_xml_sitemap.')); ?>

                            <?php echo e(translate('it_allows_search_engines_to_find_and_display_your_products_and_services_in_search_results.')); ?>

                        </div>
                    </div>
                </div>
                <div class="text-center py-3">
                    <h4 class="fs-16 mb-3">
                        <?php echo e(translate('Download_Generate_Sitemap')); ?>

                    </h4>
                    <div class="d-flex flex-wrap gap-2 justify-content-center">
                        <button id="<?php echo e(env('APP_MODE')!='demo'? 'generateAndDownloadSitemap' : ''); ?>" data-route="<?php echo e(route('admin.seo-settings.sitemap-generate-download')); ?>"
                           class="btn btn--primary px-5 d-flex gap-2 align-items-center <?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>">
                            <span class="spinner-border extra-small-spinner-border d--none" role="status" id="<?php echo e(env('APP_MODE')!='demo'? 'generateAndDownloadSitemapSpinner' : ''); ?>">
                                <span class="sr-only"><?php echo e(translate('loading').'...'); ?></span>
                            </span>
                            <span><?php echo e(translate('Generate_&_Download')); ?></span>
                        </button>
                        <a href="<?php echo e(env('APP_MODE')!='demo'? route('admin.seo-settings.sitemap-generate-upload') : 'javascript:'); ?>"
                           class="btn btn-outline--primary px-5 <?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>">
                            <?php echo e(translate('Generate_&_Upload_to_Server')); ?>

                        </a>
                        <button class="btn btn-outline--primary px-5" data-toggle="modal" data-target="#sitemap-upload-modal" type="button">
                            <?php echo e(translate('Upload_Sitemap')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card shadow-none mt-3">
            <div class="card-body p-0">
                <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table dataTable no-footer table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th class="w-95px border-0">
                                <?php echo e(translate('SL')); ?>

                            </th>
                            <th class="w-45px border-0"><?php echo e(translate('name')); ?></th>
                            <th class="w-200px text-center border-0"><?php echo e(translate('file_Size')); ?></th>
                            <th class="w-200px text-center border-0"><?php echo e(translate('date')); ?></th>
                            <th class="text-center w-60px border-0"><?php echo e(translate('action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $siteMapList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $siteMapIndex => $siteMap): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <span class="font-weight-semibold text-title">
                                        <?php echo e($siteMapList->firstItem() + $siteMapIndex); ?>

                                    </span>
                                </td>
                                <td>
                                    <span><?php echo e($siteMap['name']); ?></span>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap justify-content-center">
                                        <?php echo e($siteMap['size']); ?>

                                    </div>
                                </td>
                                <td>
                                    <div class="text-center">
                                        <span><?php echo e($siteMap['created_at']->diffForHumans()); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex justify-content-center gap-2">
                                        <a class="<?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>" href="<?php echo e(env('APP_MODE')!='demo'? route('admin.seo-settings.sitemap-download', ['path' => base64_encode($siteMap['name'])]) : 'javascript:'); ?>">
                                            <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/download.png')); ?>" alt="" width="30">
                                        </a>

                                        <a class="<?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>" href="<?php echo e(env('APP_MODE')!='demo'? route('admin.seo-settings.sitemap-delete', ['path' => base64_encode($siteMap['name'])]) : 'javascript:'); ?>">
                                            <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/delete-outlined.png')); ?>" alt="" width="30">
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="page-area px-4 pt-4">
                    <div class="d-flex align-items-center justify-content-end">
                        <div>
                            <?php echo e($siteMapList->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make("admin-views.business-settings.seo-settings._sitemap-upload-modal", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/sdmkinga/tupatane.store/resources/views/admin-views/business-settings/seo-settings/sitemap.blade.php ENDPATH**/ ?>