<div class="__inline-9 rtl">
    <div class="text-center pb-4">
        <div class="max-w-860px mx-auto footer-slider-container">
            <div class="container">
                <div class="footer-slider owl-theme owl-carousel">
                    <div class="footer-slide-item">
                        <div>
                            <a href="<?php echo e(route('about-us')); ?>">
                                <div class="text-center text-primary">
                                    <img class="object-contain svg" width="36" height="36" src="<?php echo e(theme_asset(path: "public/assets/front-end/img/icons/about-us.svg")); ?>"
                                        alt="">
                                </div>
                                <div class="text-center">
                                    <p class="m-0 mt-2">
                                        <?php echo e(translate('about_us')); ?>

                                    </p>
                                    <small class="d-none d-sm-block"><?php echo e(translate('Know_about_our_company_more.')); ?></small>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="footer-slide-item">
                        <div>
                            <a href="<?php echo e(route('contacts')); ?>">
                                <div class="text-center text-primary">
                                    <img class="object-contain svg" width="36" height="36" src="<?php echo e(theme_asset(path: "public/assets/front-end/img/icons/contact-us.svg")); ?>"
                                        alt="">
                                </div>
                                <div class="text-center">
                                    <p class="m-0 mt-2">
                                        <?php echo e(translate('contact_Us')); ?>

                                    </p>
                                    <small class="d-none d-sm-block"><?php echo e(translate('We_are_Here_to_Help')); ?></small>
                                </div>
                            </a>
                        </div>
                    </div>
                    <div class="footer-slide-item">
                        <div>
                            <a href="<?php echo e(route('helpTopic')); ?>">
                                <div class="text-center text-primary">
                                    <img class="object-contain svg" width="36" height="36" src="<?php echo e(theme_asset(path: "public/assets/front-end/img/icons/faq-icon.svg")); ?>"
                                        alt="">
                                </div>
                                <div class="text-center">
                                    <p class="m-0 mt-2">
                                        <?php echo e(translate('FAQ')); ?>

                                    </p>
                                    <small class="d-none d-sm-block"><?php echo e(translate('Get_all_Answers')); ?></small>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="page-footer font-small mdb-color rtl">
        <div class="pt-4 custom-light-primary-color-20">
            <div class="container text-center __pb-13px">

                <div
                    class="row mt-3 pb-3 ">
                    <div class="col-md-3 footer-web-logo text-center text-md-start ">
                        <a class="d-block" href="<?php echo e(route('home')); ?>">
                            <img class="<?php echo e(Session::get('direction') === "rtl" ? 'right-align' : ''); ?>"
                                 src="<?php echo e(getStorageImages(path: $web_config['footer_logo'], type: 'logo')); ?>"
                                 alt="<?php echo e($web_config['name']->value); ?>"/>
                        </a>

                        <?php if($web_config['ios']['status'] || $web_config['android']['status']): ?>
                            <div class="mt-4 pt-lg-4">
                                <h6 class="text-uppercase font-weight-bold footer-header align-items-center">
                                    <?php echo e(translate('download_our_app')); ?>

                                </h6>
                            </div>
                        <?php endif; ?>

                        <div class="store-contents d-flex justify-content-center pr-lg-4">
                            <?php if($web_config['ios']['status']): ?>
                                <div class="me-2 mb-2">
                                    <a class="" href="<?php echo e($web_config['ios']['link']); ?>" role="button">
                                        <img width="100" src="<?php echo e(theme_asset(path: "public/assets/front-end/png/apple_app.png")); ?>"
                                             alt="">
                                    </a>
                                </div>
                            <?php endif; ?>

                            <?php if($web_config['android']['status']): ?>
                                <div class="me-2 mb-2">
                                    <a href="<?php echo e($web_config['android']['link']); ?>" role="button">
                                        <img width="100" src="<?php echo e(theme_asset(path: "public/assets/front-end/png/google_app.png")); ?>"
                                             alt="">
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="row">
                            <div class="col-sm-3 col-6 footer-padding-bottom text-start">
                                <h6 class="text-uppercase mobile-fs-12 font-semi-bold footer-header"><?php echo e(translate('special')); ?></h6>
                                <ul class="widget-list __pb-10px">
                                    <?php ($flash_deals=\App\Models\FlashDeal::where(['status'=>1,'deal_type'=>'flash_deal'])->whereDate('start_date','<=',date('Y-m-d'))->whereDate('end_date','>=',date('Y-m-d'))->first()); ?>
                                    <?php if(isset($flash_deals)): ?>
                                        <li class="widget-list-item">
                                            <a class="widget-list-link"
                                               href="<?php echo e(route('flash-deals',[$flash_deals['id']])); ?>">
                                                <?php echo e(translate('flash_deal')); ?>

                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <li class="widget-list-item">
                                        <a class="widget-list-link"
                                           href="<?php echo e(route('products',['data_from'=>'featured','page'=>1])); ?>">
                                            <?php echo e(translate('featured_products')); ?>

                                        </a>
                                    </li>
                                    <li class="widget-list-item">
                                        <a class="widget-list-link"
                                           href="<?php echo e(route('products',['data_from'=>'latest','page'=>1])); ?>">
                                            <?php echo e(translate('latest_products')); ?>

                                        </a>
                                    </li>
                                    <li class="widget-list-item">
                                        <a class="widget-list-link"
                                           href="<?php echo e(route('products',['data_from'=>'best-selling','page'=>1])); ?>">
                                            <?php echo e(translate('best_selling_product')); ?>

                                        </a>
                                    </li>
                                    <li class="widget-list-item">
                                        <a class="widget-list-link"
                                           href="<?php echo e(route('products',['data_from'=>'top-rated','page'=>1])); ?>">
                                            <?php echo e(translate('top_rated_product')); ?>

                                        </a>
                                    </li>

                                </ul>
                            </div>
                            <div class="col-sm-4 col-6 footer-padding-bottom text-start">
                                <h6 class="text-uppercase mobile-fs-12 font-semi-bold footer-header"><?php echo e(translate('account_&_shipping_info')); ?></h6>
                                <?php ($refund_policy = getWebConfig(name: 'refund-policy')); ?>
                                <?php ($return_policy = getWebConfig(name: 'return-policy')); ?>
                                <?php ($cancellation_policy = getWebConfig(name: 'cancellation-policy')); ?>
                                <?php ($shippingPolicy = getWebConfig(name: 'shipping-policy')); ?>
                                <?php if(auth('customer')->check()): ?>
                                    <ul class="widget-list __pb-10px">
                                        <li class="widget-list-item">
                                            <a class="widget-list-link" href="<?php echo e(route('user-account')); ?>">
                                                <?php echo e(translate('profile_info')); ?>

                                            </a>
                                        </li>

                                        <li class="widget-list-item">
                                            <a class="widget-list-link" href="<?php echo e(route('track-order.index')); ?>">
                                                <?php echo e(translate('track_order')); ?>

                                            </a>
                                        </li>

                                        <?php if(isset($refund_policy['status']) && $refund_policy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link" href="<?php echo e(route('refund-policy')); ?>">
                                                    <?php echo e(translate('refund_policy')); ?>

                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($return_policy['status']) && $return_policy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link" href="<?php echo e(route('return-policy')); ?>">
                                                    <?php echo e(translate('return_policy')); ?>

                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($cancellation_policy['status']) && $cancellation_policy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link" href="<?php echo e(route('cancellation-policy')); ?>">
                                                    <?php echo e(translate('cancellation_policy')); ?>

                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($shippingPolicy['status']) && $shippingPolicy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link" href="<?php echo e(route('shipping-policy')); ?>">
                                                    <?php echo e(translate('Shipping_Policy')); ?>

                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                <?php else: ?>
                                    <ul class="widget-list __pb-10px">
                                        <li class="widget-list-item">
                                            <a class="widget-list-link"
                                               href="<?php echo e(route('customer.auth.login')); ?>"><?php echo e(translate('profile_info')); ?></a>
                                        </li>
                                        <li class="widget-list-item">
                                            <a class="widget-list-link"
                                               href="<?php echo e(route('customer.auth.login')); ?>"><?php echo e(translate('wish_list')); ?></a>
                                        </li>

                                        <li class="widget-list-item">
                                            <a class="widget-list-link"
                                               href="<?php echo e(route('track-order.index')); ?>"><?php echo e(translate('track_order')); ?></a>
                                        </li>

                                        <?php if(isset($refund_policy['status']) && $refund_policy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link"
                                                   href="<?php echo e(route('refund-policy')); ?>"><?php echo e(translate('refund_policy')); ?></a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($return_policy['status']) && $return_policy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link"
                                                   href="<?php echo e(route('return-policy')); ?>"><?php echo e(translate('return_policy')); ?></a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($cancellation_policy['status']) && $cancellation_policy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link"
                                                   href="<?php echo e(route('cancellation-policy')); ?>"><?php echo e(translate('cancellation_policy')); ?></a>
                                            </li>
                                        <?php endif; ?>

                                        <?php if(isset($shippingPolicy['status']) && $shippingPolicy['status'] == 1): ?>
                                            <li class="widget-list-item">
                                                <a class="widget-list-link" href="<?php echo e(route('shipping-policy')); ?>">
                                                    <?php echo e(translate('shipping_Policy')); ?>

                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                            <div class="col-sm-5 footer-padding-bottom offset-max-sm--1 pb-3 pb-sm-0">
                                <div class="mb-2">
                                    <h6 class="text-uppercase mobile-fs-12 font-semi-bold footer-header text-center text-sm-start"><?php echo e(translate('newsletter')); ?></h6>
                                    <div class="text-center text-sm-start mobile-fs-12"><?php echo e(translate('subscribe_to_our_new_channel_to_get_latest_updates')); ?></div>
                                </div>
                                <div class="text-nowrap mb-4 position-relative">
                                    <form action="<?php echo e(route('subscription')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="email" name="subscription_email"
                                               class="form-control subscribe-border text-align-direction p-12px"
                                               placeholder="<?php echo e(translate('your_Email_Address')); ?>" required>
                                        <button class="subscribe-button" type="submit">
                                            <?php echo e(translate('subscribe')); ?>

                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-4 <?php echo e(Session::get('direction') === "rtl" ? ' flex-row-reverse' : ''); ?>">
                            <div class="col-md-7">
                                <div
                                    class="d-flex align-items-center mobile-view-center-align text-start justify-content-between">
                                    <div class="me-3">
                                        <span class="mb-4 font-weight-bold footer-header text-capitalize"><?php echo e(translate('start_a_conversation')); ?></span>
                                    </div>
                                    <div
                                        class="flex-grow-1 d-none d-md-block <?php echo e(Session::get('direction') === "rtl" ? 'mr-4 mx-sm-4' : 'mx-sm-4'); ?>">
                                        <hr>
                                    </div>
                                </div>
                                <div class="row text-start">
                                    <div class="col-12 start_address ">
                                        <div class="">
                                            <a class="widget-list-link" href="<?php echo e('tel:'.$web_config['phone']->value); ?>">
                                                <span class="">
                                                    <i class="fa fa-phone  me-2 mt-2 mb-2"></i>
                                                    <span class="direction-ltr">
                                                        <?php echo e(getWebConfig(name: 'company_phone')); ?>

                                                    </span>
                                                </span>
                                            </a>

                                        </div>
                                        <div>
                                            <a class="widget-list-link"
                                               href="<?php echo e('mailto:'.getWebConfig(name: 'company_email')); ?>">
                                                <span><i class="fa fa-envelope  me-2 mt-2 mb-2"></i> <?php echo e(getWebConfig(name: 'company_email')); ?> </span>
                                            </a>
                                        </div>
                                        <div class="pe-3">
                                            <?php if(auth('customer')->check()): ?>
                                                <a class="widget-list-link" href="<?php echo e(route('account-tickets')); ?>">
                                                    <span><i class="fa fa-user-o  me-2 mt-2 mb-2"></i> <?php echo e(translate('support_ticket')); ?> </span>
                                                </a>
                                                <br class="d-none d-md-block" />
                                            <?php else: ?>
                                                <a class="widget-list-link" href="<?php echo e(route('customer.auth.login')); ?>">
                                                    <span><i class="fa fa-user-o  me-2 mt-2 mb-2"></i> <?php echo e(translate('support_ticket')); ?> </span>
                                                </a>
                                                <br class="d-none d-md-block" />
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5 text-start">
                                <div
                                    class="row d-flex align-items-center mobile-view-center-align justify-content-center justify-content-md-start pb-0">
                                    <div class="d-none d-md-block">
                                        <span class="mb-4 font-weight-bold footer-header"><?php echo e(translate('address')); ?></span>
                                    </div>
                                    <div
                                        class="flex-grow-1 d-none d-md-block <?php echo e(Session::get('direction') === "rtl" ? 'mr-3 ' : 'ml-3'); ?>">
                                        <hr class="address_under_line"/>
                                    </div>
                                </div>
                                <div>
                                    <span
                                        class="__text-14px d-flex align-items-center">
                                        <i class="fa fa-map-marker me-2 mt-2 mb-2"></i>
                                        <span><?php echo e(getWebConfig(name: 'shop_address')); ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="bg-white-overlay-50">
            <div class="container">
                <div class="d-flex flex-wrap end-footer footer-end last-footer-content-align text-center pt-3 pb-4 py-md-0">
                    <div class="mt-3">
                        <p class="__text-16px"><?php echo e($web_config['copyright_text']->value); ?></p>
                    </div>
                    <div
                        class="max-sm-100 justify-content-center d-flex flex-wrap mt-md-3 mt-0 mb-md-3">
                        <?php if($web_config['social_media']): ?>
                            <?php $__currentLoopData = $web_config['social_media']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="social-media ">
                                    <?php if($item->name == "twitter"): ?>
                                        <a class="social-btn text-white sb-light sb-<?php echo e($item->name); ?> me-2 mb-2 d-flex justify-content-center align-items-center"
                                           target="_blank" href="<?php echo e($item->link); ?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="16"
                                                 height="16" viewBox="0 0 24 24">
                                                <g opacity=".3">
                                                    <polygon fill="#fff" fill-rule="evenodd"
                                                     points="16.002,19 6.208,5 8.255,5 18.035,19"
                                                             clip-rule="evenodd">
                                                    </polygon>
                                                    <polygon points="8.776,4 4.288,4 15.481,20 19.953,20 8.776,4">
                                                    </polygon>
                                                </g>
                                                <polygon fill-rule="evenodd"
                                                         points="10.13,12.36 11.32,14.04 5.38,21 2.74,21"
                                                    clip-rule="evenodd">
                                                </polygon>
                                                <polygon fill-rule="evenodd"
                                                         points="20.74,3 13.78,11.16 12.6,9.47 18.14,3"
                                                         clip-rule="evenodd">
                                                </polygon>
                                                <path
                                                    d="M8.255,5l9.779,14h-2.032L6.208,5H8.255 M9.298,3h-6.93l12.593,18h6.91L9.298,3L9.298,3z"
                                                    fill="currentColor">
                                                </path>
                                            </svg>
                                        </a>
                                    <?php else: ?>
                                        <a class="social-btn text-white sb-light sb-<?php echo e($item->name); ?> me-2 mb-2"
                                           target="_blank" href="<?php echo e($item->link); ?>">
                                            <i class="<?php echo e($item->icon); ?>" aria-hidden="true"></i>
                                        </a>
                                    <?php endif; ?>
                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex __text-14px justify-content-center">
                        <div class="me-3">
                            <a class="widget-list-link"
                               href="<?php echo e(route('terms')); ?>"><?php echo e(translate('terms_&_conditions')); ?></a>
                        </div>
                        <div>
                            <a class="widget-list-link" href="<?php echo e(route('privacy-policy')); ?>">
                                <?php echo e(translate('privacy_policy')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php ($cookie = $web_config['cookie_setting'] ? json_decode($web_config['cookie_setting']['value'], true):null); ?>
        <?php if($cookie && $cookie['status']==1): ?>
            <section id="cookie-section"></section>
        <?php endif; ?>
    </footer>
</div>
<?php /**PATH /home/tupatane/public_html/resources/themes/default/layouts/front-end/partials/_footer.blade.php ENDPATH**/ ?>