<?php $__env->startSection('title', translate('review_List')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize">
                <img width="20" src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/product-review.png')); ?>" class="mb-1 mr-1"
                     alt="">
                <?php echo e(translate('product_reviews')); ?>

            </h2>
        </div>
        <div class="card card-body">
            <div class="row border-bottom pb-3 align-items-center mb-20">
                <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                    <h5 class="text-capitalize mb-0 d-flex gap-1">
                        <?php echo e(translate('review_table')); ?>

                        <span class="badge badge-soft-dark radius-50 fz-12"><?php echo e($reviews->total()); ?></span>
                    </h5>
                </div>
                <div class="col-sm-8 col-md-6 col-lg-4">
                    <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="input-group input-group-merge input-group-custom">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="tio-search"></i>
                                </div>
                            </div>
                            <input id="datatableSearch_" type="search" name="searchValue" class="form-control"
                                   placeholder="<?php echo e(translate('search_by_Product_or_Customer')); ?>"
                                   aria-label="Search orders" value="<?php echo e($searchValue); ?>" required>
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('search')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
            <form action="<?php echo e(url()->current()); ?>" method="GET">
                <div class="row">
                    <div class="col-md-4">
                        <div class="mb-2">
                            <label for="name" class="title-color"><?php echo e(translate('products')); ?></label>
                            <div class="dropdown select-product-search w-100">
                                <input type="text" class="product_id" name="product_id" value="<?php echo e(request('product_id')); ?>"
                                       hidden>
                                <button class="form-control text-start dropdown-toggle selected-product-name text-truncate select-product-button"
                                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" type="button">
                                    <?php echo e(request('product_id') !=null ? $product['name']: translate('select_Product')); ?>

                                </button>
                                <div class="dropdown-menu w-100 px-2">
                                    <div class="search-form mb-3">
                                        <button type="button" class="btn"><i class="tio-search"></i></button>
                                        <input type="text" class="js-form-search form-control search-bar-input search-product" placeholder="<?php echo e(translate('search menu').'...'); ?>">
                                    </div>
                                    <div class="d-flex flex-column gap-3 max-h-40vh overflow-y-auto overflow-x-hidden search-result-box">
                                        <?php echo $__env->make('vendor-views.partials._search-product', ['products'=> $products], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-2">
                            <label class="title-color" for="customer"><?php echo e(translate('customer')); ?></label>
                            <input type="hidden" id='customer_id' name="customer_id"
                                   value="<?php echo e(request('customer_id') ? request('customer_id') : 'all'); ?>">
                            <select data-placeholder="
                                        <?php if($customer == 'all'): ?>
                                            <?php echo e(translate('all_customer')); ?>

                                        <?php else: ?>
                                            <?php echo e($customer['name'] ?? $customer['f_name'].' '.$customer['l_name'].' '.'('.$customer['phone'].')'); ?>

                                        <?php endif; ?>"
                                    class="get-customer-list-by-ajax-request form-control form-ellipsis set-customer-value">
                                <option value="all"><?php echo e(translate('all_customer')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-2">
                            <label for="status" class="title-color d-flex"><?php echo e(translate('choose')); ?>

                                <?php echo e(translate('status')); ?></label>
                            <select class="form-control" name="status">
                                <option value="" selected> <?php echo e('---'.translate('select_status').'---'); ?> </option>
                                <option value="1" <?php echo e(isset($status) && $status == 1 ? 'selected' : ''); ?>>
                                    <?php echo e(translate('active')); ?></option>
                                <option value="0" <?php echo e(isset($status) && $status == 0 ? 'selected' : ''); ?>>
                                    <?php echo e(translate('inactive')); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-2">
                            <label for="from" class="title-color d-flex"><?php echo e(translate('from')); ?></label>
                            <input type="date" name="from" id="start-date-time" value="<?php echo e($from); ?>"
                                   class="form-control"
                                   title="<?php echo e(translate('from_date')); ?>">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="mb-2">
                            <label for="to" class="title-color d-flex"><?php echo e(translate('to')); ?></label>
                            <input type="date" name="to" id="end-date-time" value="<?php echo e($to); ?>"
                                   class="form-control"
                                   title="<?php echo e(ucfirst(translate('to_date'))); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="d-flex align-items-end h-100">
                            <div class="mb-2 form-group w-100">
                                <button id="filter" type="submit" class="btn btn--primary btn-block filter">
                                    <i class="tio-filter-list nav-icon"></i><?php echo e(translate('filter')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="d-flex align-items-end h-100">
                            <div class="mb-2 form-group w-100">
                                <button type="button" class="btn btn-outline--primary w-100" data-toggle="dropdown">
                                    <i class="tio-download-to"></i>
                                    <?php echo e(translate('export')); ?>

                                    <i class="tio-chevron-down"></i>
                                </button>

                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li>
                                        <a type="submit" class="dropdown-item"
                                           href="<?php echo e(route('vendor.reviews.export', ['product_id' => $product_id, 'customer_id' => $customer_id, 'status' => $status, 'from' => $from, 'to' => $to])); ?>">
                                            <img width="14" src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/excel.png')); ?>"
                                                 alt="">
                                            <?php echo e(translate('excel')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="card mt-20">
            <?php ($vendorReviewReplyStatus = getWebConfig('vendor_review_reply_status') ?? 0); ?>
            <div class="table-responsive datatable-custom">
                <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table text-start">
                    <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(translate('SL')); ?></th>
                        <th><?php echo e(translate('Review_ID')); ?></th>
                        <th><?php echo e(translate('product')); ?></th>
                        <th><?php echo e(translate('customer')); ?></th>
                        <th><?php echo e(translate('rating')); ?></th>
                        <th><?php echo e(translate('review')); ?></th>
                        <th><?php echo e(translate('Reply')); ?></th>
                        <th><?php echo e(translate('date')); ?></th>
                        <th class="text-center"><?php echo e(translate('status')); ?></th>
                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($review->product): ?>
                            <tr>
                                <td>
                                    <?php echo e($reviews->firstItem()+$key); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo e($review->id); ?>

                                </td>
                                <td>
                                    <a class="title-color hover-c1"
                                       href="<?php echo e(route('vendor.products.view', [$review['product_id']])); ?>">
                                        <?php echo e(Str::limit($review->product['name'], 25)); ?>

                                    </a>
                                </td>
                                <td>
                                    <?php if($review->customer): ?>
                                        <?php echo e($review->customer->f_name . ' ' . $review->customer->l_name); ?>

                                    <?php else: ?>
                                        <label class="badge badge-soft-danger"><?php echo e(translate('customer_removed')); ?></label>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <label class="badge badge-soft-info mb-0">
                                            <span class="fz-12 d-flex align-items-center gap-1"><?php echo e($review->rating); ?> <i
                                                        class="tio-star"></i>
                                            </span>
                                    </label>
                                </td>
                                <td>
                                    <div class="gap-1">
                                        <div><?php echo e($review->comment ? Str::limit($review->comment, 35) : translate('no_comment_found')); ?></div>
                                        <br>
                                        <?php if($review->attachment_full_url): ?>
                                            <div class="d-flex flex-wrap gap-1 min-w-200">
                                                <?php $__currentLoopData = $review->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a href="<?php echo e(getStorageImages(path:$img,type: 'backend-basic')); ?>"
                                                       data-lightbox="mygallery<?php echo e($review['id']); ?>">
                                                        <img width="60" height="60"
                                                             class="aspect-1 rounded object-fit-cover"
                                                             src="<?php echo e(getStorageImages(path:$img,type: 'backend-basic')); ?>"
                                                             alt="<?php echo e(translate('image')); ?>">
                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <div class="line--limit-2 max-w-250 word-break">
                                        <?php echo e($review?->reply?->reply_text ?? '-'); ?>

                                    </div>
                                </td>
                                <td><?php echo e(date('d M Y', strtotime($review->created_at))); ?></td>
                                <td>
                                    <form action="<?php echo e(route('vendor.reviews.update-status', [$review['id'], $review->status ? 0 : 1])); ?>"
                                          method="get" id="reviews-status<?php echo e($review['id']); ?>-form"
                                          class="reviews_status_form">
                                        <label class="switcher mx-auto">
                                            <input type="checkbox" class="switcher_input toggle-switch-message"
                                                   id="reviews-status<?php echo e($review['id']); ?>"
                                                   <?php echo e($review->status ? 'checked' : ''); ?>

                                                   data-modal-id = "toggle-status-modal"
                                                   data-toggle-id = "reviews-status<?php echo e($review['id']); ?>"
                                                   data-on-image = "customer-reviews-on.png"
                                                   data-off-image = "customer-reviews-off.png"
                                                   data-on-title = "<?php echo e(translate('Want_to_Turn_ON_Customer_Reviews').'?'); ?>"
                                                   data-off-title = "<?php echo e(translate('Want_to_Turn_OFF_Customer_Reviews').'?'); ?>"
                                                   data-on-message = "<p><?php echo e(translate('if_enabled_anyone_can_see_this_review_on_the_user_website_and_customer_app')); ?></p>"
                                                   data-off-message = "<p><?php echo e(translate('if_disabled_this_review_will_be_hidden_from_the_user_website_and_customer_app')); ?></p>">`)">
                                            <span class="switcher_control"></span>
                                        </label>
                                    </form>
                                </td>
                                <td>
                                    <div class="d-flex gap-2 justify-content-center">
                                        <div data-toggle="modal" data-target="#review-view-for-<?php echo e($review['id']); ?>">
                                            <a class="btn btn-outline-info btn-sm square-btn" title="<?php echo e(translate('View')); ?>" data-toggle="tooltip">
                                                <i class="tio-invisible"></i>
                                            </a>
                                        </div>

                                        <?php if($vendorReviewReplyStatus): ?>
                                            <div data-toggle="modal" data-target="#review-update-for-<?php echo e($review['id']); ?>">
                                                <?php if($review?->reply): ?>
                                                    <a class="btn btn-outline-primary btn-sm square-btn" title="<?php echo e(translate('Update_Review')); ?>" data-toggle="tooltip">
                                                        <i class="tio-edit"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <div class="btn btn-outline--primary btn-sm square-btn" title="<?php echo e(translate('Review_Reply')); ?>" data-toggle="tooltip">
                                                        <i class="tio-reply-all"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($review->customer)): ?>
                    <div class="modal fade" id="review-update-for-<?php echo e($review['id']); ?>" tabindex="-1" aria-labelledby="exampleModalLabel"
                         aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close text-BFBFBF" data-dismiss="modal" aria-label="Close">
                                        <i class="tio-clear-circle"></i>
                                    </button>
                                </div>
                                <form method="POST" action="<?php echo e(route('vendor.reviews.add-review-reply')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body pt-0">
                                        <div class="d-flex flex-wrap align-items-center gap-3 mb-3">
                                            <?php if(isset($review->product)): ?>
                                                <img src="<?php echo e(getStorageImages(path:$review?->product?->thumbnail_full_url, type: 'backend-product')); ?>" width="100" class="rounded aspect-1 border" alt="">
                                                <div class="w-0 flex-grow-1 font-weight-semibold">
                                                    <?php if($review['order_id']): ?>
                                                        <div class="mb-2">
                                                            <?php echo e(translate('Order_ID')); ?> # <?php echo e($review['order_id']); ?>

                                                        </div>
                                                    <?php endif; ?>
                                                    <h4 class="line--limit-2"><?php echo e($review->product['name']); ?></h4>
                                                </div>
                                            <?php else: ?>
                                                <span class="title-color">
                                                    <?php echo e(translate('product_not_found')); ?>

                                                </span>
                                            <?php endif; ?>

                                        </div>
                                        <label class="input-label text--title font-weight-bold">
                                            <?php echo e(translate('Review')); ?>

                                        </label>
                                        <div class="__bg-F3F5F9 p-3 rounded border mb-2">
                                            <?php echo e($review['comment']); ?>

                                        </div>
                                        <div class="d-flex flex-wrap gap-2">
                                            <?php if(count($review->attachment_full_url)>0): ?>
                                                <?php $__currentLoopData = $review->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a class="aspect-1 float-left overflow-hidden"
                                                       href="<?php echo e(getStorageImages(path:$img,type: 'backend-basic')); ?>"
                                                       data-lightbox="review-gallery-modal<?php echo e($review['id']); ?>" >
                                                        <img width="45" class="rounded aspect-1 border"
                                                             src="<?php echo e(getStorageImages(path:$img,type: 'backend-basic')); ?>"
                                                             alt="<?php echo e(translate('review_image')); ?>">
                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </div>
                                        <label class="input-label text--title font-weight-bold pt-4">
                                            <?php echo e(translate('Reply')); ?>

                                        </label>
                                        <input type="hidden" name="review_id" value="<?php echo e($review['id']); ?>">
                                        <textarea class="form-control text-area-max-min" rows="3" name="reply_text"
                                                  placeholder="<?php echo e(translate('Write_the_reply_of_the_product_review')); ?>..."><?php echo e($review?->reply?->reply_text ?? ''); ?></textarea>
                                        <div class="text-right mt-4">
                                            <button type="submit" class="btn btn--primary">
                                                <?php if($review?->reply?->reply_text): ?>
                                                    <?php echo e(translate('Update')); ?>

                                                <?php else: ?>
                                                    <?php echo e(translate('submit')); ?>

                                                <?php endif; ?>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                    <div class="modal fade" id="review-view-for-<?php echo e($review['id']); ?>" tabindex="-1" aria-labelledby="exampleModalLabel"
                         aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close text-BFBFBF" data-dismiss="modal" aria-label="Close">
                                        <i class="tio-clear-circle"></i>
                                    </button>
                                </div>
                                <div class="modal-body pt-0">
                                    <div class="d-flex flex-wrap align-items-center gap-3 mb-3 text-center border-bottom">
                                        <div class="w-0 flex-grow-1 font-weight-semibold">
                                            <div class="mb-2">
                                                <?php echo e(translate('Review_ID')); ?> # <?php echo e($review['id']); ?>

                                            </div>

                                            <?php if($review['order_id']): ?>
                                                <div class="mb-2">
                                                    <?php echo e(translate('Order_ID')); ?> # <?php echo e($review['order_id']); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <h2 class="text-center">
                                        <span class="text-primary"><?php echo e($review['rating'].'.0'); ?></span><span class="fz-16 text-muted"><?php echo e('/5'); ?></span>
                                    </h2>
                                    <div class="d-flex align-items-center gap-1 text-primary justify-content-center fz-14 mb-4">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $review['rating']): ?>
                                                <i class="tio-star"></i>
                                            <?php else: ?>
                                                <i class="tio-star-outlined"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>

                                    <label class="input-label text--title font-weight-bold">
                                        <?php echo e(translate('Review')); ?>

                                    </label>
                                    <div class="__bg-F3F5F9 p-3 rounded border mb-2">
                                        <?php echo e($review['comment']); ?>

                                    </div>
                                    <div class="d-flex flex-wrap gap-2">
                                        <?php if(count($review->attachment_full_url) > 0): ?>
                                            <?php $__currentLoopData = $review->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="aspect-1 float-left overflow-hidden"
                                                   href="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                   data-lightbox="review-gallery-modal<?php echo e($review['id']); ?>" >
                                                    <img width="45" class="rounded aspect-1 border"
                                                         src="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                         alt="<?php echo e(translate('review_image')); ?>">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($review?->reply?->reply_text): ?>
                                        <label class="input-label text--title font-weight-bold pt-4">
                                            <?php echo e(translate('Reply')); ?>

                                        </label>
                                        <div class="__bg-F3F5F9 p-3 rounded border mb-2">
                                            <?php echo e($review?->reply?->reply_text ?? ''); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <?php echo $reviews->links(); ?>

                </div>
            </div>
            <?php if(count($reviews)==0): ?>
                <?php echo $__env->make('layouts.back-end._empty-state',['text'=>'no_review_found'],['image'=>'default'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/search-product.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/kariakooyetu/public_html/resources/views/vendor-views/reviews/index.blade.php ENDPATH**/ ?>