<div class="card mt-2 category">
    <div class="card-body">
        <div class="row">
            <div class="col-lg-6">
                <div class="">
                    <h3 class="mb-3 text-capitalize"><?php echo e(translate('category')); ?></h3>
                    <p class="max-w-400"><?php echo e(translate('the_category_list_groups_similar_products_together_arranged_with_the_latest_category_first_and_in_alphabetical_order')); ?></p>
                </div>
            </div>
            <div class="col-lg-6">
                <form action="<?php echo e(route('admin.business-settings.priority-setup.index',['type'=>'category'])); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="border rounded p-3 d-flex gap-4 flex-column">
                        <div class="d-flex gap-2 justify-content-between pb-3 border-bottom">
                            <div class="d-flex flex-column">
                                <h5 class="text-capitalize"><?php echo e(translate('use_default_sorting_list')); ?></h5>
                                <div class="d-flex gap-2 align-items-center">
                                    <img width="14" src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/icons/info.svg')); ?>" alt="">
                                    <span class="text-dark fz-12"><?php echo e(translate('currently_sorting_this_section_based_on_priority_wise')); ?></span>
                                </div>
                            </div>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input switcher-input-js" data-parent-class="category" data-from="default-sorting"
                                    <?php echo e($categoryPriority?->custom_sorting_status == 1 ? '' : 'checked'); ?>>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                        <div class="">
                            <div class="d-flex gap-2 justify-content-between">
                                <div class="d-flex flex-column">
                                    <h5 class="text-capitalize"><?php echo e(translate('use_custom_sorting_list')); ?></h5>
                                    <div class="d-flex gap-2 align-items-center">
                                        <img width="14" src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/icons/info.svg')); ?>" alt="">
                                        <span class="text-dark fz-12"><?php echo e(translate('you_can_sorting_this_section_by_others_way')); ?></span>
                                    </div>
                                </div>
                                <label class="switcher">
                                    <input type="checkbox" class="switcher_input switcher-input-js" name="custom_sorting_status" value="1" data-parent-class="category" data-from="custom-sorting"
                                        <?php echo e(isset($categoryPriority?->custom_sorting_status) && $categoryPriority?->custom_sorting_status == 1 ? 'checked' : ''); ?>>
                                    <span class="switcher_control"></span>
                                </label>
                            </div>

                            <div class="custom-sorting-radio-list <?php echo e(isset($categoryPriority?->custom_sorting_status) && $categoryPriority?->custom_sorting_status == 1 ? '' : 'd--none'); ?>">
                                <div class="border rounded p-3 d-flex flex-column gap-2 mt-4">
                                    <div class="d-flex gap-2 align-items-center">
                                        <input type="radio" class="show" name="sort_by" value="latest_created" id="category-sort-by-latest-created"
                                            <?php echo e(isset($categoryPriority?->sort_by) && $categoryPriority?->sort_by == 'latest_created' ? 'checked' : ''); ?>>
                                        <label class="mb-0 cursor-pointer" for="category-sort-by-latest-created">
                                            <?php echo e(translate('sort_by_latest_created')); ?>

                                        </label>
                                    </div>
                                    <div class="d-flex gap-2 align-items-center">
                                        <input type="radio" class="show" name="sort_by" value="first_created" id="category-sort-by-first-created"
                                            <?php echo e(isset($categoryPriority?->sort_by) && $categoryPriority?->sort_by == 'first_created' ? 'checked' : ''); ?>>
                                        <label class="mb-0 cursor-pointer" for="category-sort-by-first-created">
                                            <?php echo e(translate('sort_by_first_created')); ?>

                                        </label>
                                    </div>
                                    <div class="d-flex gap-2 align-items-center">
                                        <input type="radio" class="show" name="sort_by" value="most_order" id="category-sort-by-most-order"
                                            <?php echo e(isset($categoryPriority?->sort_by) ? ($categoryPriority?->sort_by == 'most_order' ? 'checked' : '') : 'checked'); ?>>
                                        <label class="mb-0 cursor-pointer text-capitalize" for="category-sort-by-most-order">
                                            <?php echo e(translate('sort_by_most_order')); ?>

                                        </label>
                                    </div>

                                    <div class="d-flex gap-2 align-items-center">
                                        <input type="radio" class="show" name="sort_by" value="a_to_z" id="category-alphabetic-order"
                                            <?php echo e(isset($categoryPriority?->sort_by) && $categoryPriority?->sort_by == 'a_to_z' ? 'checked' : ''); ?>>
                                        <label class="mb-0 cursor-pointer text-capitalize" for="category-alphabetic-order">
                                            <?php echo e(translate('sort_by_Alphabetical')); ?> (<?php echo e('A '.translate('to').' Z'); ?>)
                                        </label>
                                    </div>

                                    <div class="d-flex gap-2 align-items-center">
                                        <input type="radio" class="show" name="sort_by" value="z_to_a" id="category-alphabetic-order-reverse"
                                            <?php echo e(isset($categoryPriority?->sort_by) && $categoryPriority?->sort_by == 'z_to_a' ? 'checked' : ''); ?>>
                                        <label class="mb-0 cursor-pointer text-capitalize" for="category-alphabetic-order-reverse">
                                            <?php echo e(translate('sort_by_Alphabetical')); ?> (<?php echo e('Z '.translate('to').' A'); ?>)
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="d-flex justify-content-end mt-4">
                        <button type="submit" class="btn btn-primary px-5"><?php echo e(translate('save')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /data/kariakooyetu/public_html/resources/views/admin-views/business-settings/priority-setup/partial/category.blade.php ENDPATH**/ ?>